LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.std_logic_unsigned.ALL;
PACKAGE count_types IS
  SUBTYPE bit4 IS std_logic_vector(3 DOWNTO 0);
END count_types;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.std_logic_unsigned.ALL;
USE WORK.count_types.ALL;
ENTITY count IS
  PORT( clock, load, clear : IN std_logic;
        din : IN bit4;
        dout : INOUT bit4);
END count;

ARCHITECTURE synth OF count IS
  SIGNAL count_val : bit4;
BEGIN
  PROCESS(load, clear, din, dout)
  BEGIN
    IF (clear = '1') THEN
      count_val <= "0000";
    ELSIF (load = '1') THEN
      count_val <= din;
    ELSE
      count_val <= dout + "0001";
    END IF;
    
  END PROCESS;
  
  PROCESS
  BEGIN

    WAIT UNTIL clock'EVENT and clock = '1';

    dout <= count_val;
  END PROCESS;
END synth;

